/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.serializers;

import com.google.gson.JsonObject;
import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.blocks.FlexBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexDirectionalBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexDoorBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexFallingBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexFenceBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexFenceGateBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexHorizontalDirectionalBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexLeavesBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexLiquidBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexRotatedPillarBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexSaplingBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexSlabBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexStairsBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexTrapdoorBlock;
import dev.gigaherz.jsonthings.things.blocks.FlexWallBlock;
import dev.gigaherz.jsonthings.things.builders.BlockBuilder;
import dev.gigaherz.jsonthings.things.misc.FlexTreeGrower;
import dev.gigaherz.jsonthings.things.serializers.IBlockFactory;
import dev.gigaherz.jsonthings.things.serializers.IBlockSerializer;
import dev.gigaherz.jsonthings.util.Utils;
import dev.gigaherz.jsonthings.util.parse.JParse;
import dev.gigaherz.jsonthings.util.parse.value.ObjValue;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;

public class FlexBlockType<T extends Block> {
    public static final FlexBlockType<FlexBlock> PLAIN = FlexBlockType.register("plain", (JsonObject data) -> (props, builder) -> {
        final List<Property<?>> _properties = builder.getProperties();
        Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
        return new FlexBlock(props, propertyDefaultValues){

            protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                super.m_7926_(builder1);
                _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
            }
        };
    }, "solid", false, false, false, new Property[0]);
    public static final FlexBlockType<FlexFallingBlock> FALLING = FlexBlockType.register("falling", (JsonObject data) -> {
        MutableInt dustColor = new MutableInt(-1);
        JParse.begin(data).ifKey("dust_color", val -> val.ifInteger(num -> num.handle(color -> dustColor.setValue(color))).ifObj(num -> num.map(obj -> {
            int r = GsonHelper.m_13927_((JsonObject)obj, (String)"r");
            int g = GsonHelper.m_13927_((JsonObject)obj, (String)"g");
            int b = GsonHelper.m_13927_((JsonObject)obj, (String)"b");
            int a = GsonHelper.m_13824_((JsonObject)obj, (String)"a", (int)255);
            return FastColor.ARGB32.m_13660_((int)a, (int)r, (int)g, (int)b);
        }).handle(arg_0 -> ((MutableInt)dustColor).setValue(arg_0))).typeError());
        return (props, builder) -> {
            final List<Property<?>> _properties = builder.getProperties();
            Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
            return new FlexFallingBlock(dustColor.getValue(), props, propertyDefaultValues){

                protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                    super.m_7926_(builder1);
                    _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
                }
            };
        };
    }, "cutout", false, false, false, new Property[0]);
    public static final FlexBlockType<FlexSaplingBlock> SAPLING = FlexBlockType.register("sapling", (JsonObject data) -> (props, builder) -> {
        final List<Property<?>> _properties = builder.getProperties();
        Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
        ResourceLocation featureId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)data, (String)"tree_feature"));
        ResourceKey featureKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)featureId);
        FlexTreeGrower treeGrower = new FlexTreeGrower(featureKey);
        return new FlexSaplingBlock(treeGrower, props, propertyDefaultValues){

            protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                super.m_7926_(builder1);
                _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
            }
        };
    }, "cutout", false, false, false, new Property[0]);
    public static final FlexBlockType<FlexDirectionalBlock> DIRECTIONAL = FlexBlockType.register("directional", (JsonObject data) -> (props, builder) -> {
        final List<Property<?>> _properties = builder.getProperties();
        Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
        return new FlexDirectionalBlock(props, propertyDefaultValues){

            protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                super.m_7926_(builder1);
                _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
            }
        };
    }, "solid", false, false, false, new Property[]{DirectionalBlock.f_52588_});
    public static final FlexBlockType<FlexHorizontalDirectionalBlock> HORIZONTAL_DIRECTIONAL = FlexBlockType.register("horizontal_directional", (JsonObject data) -> (props, builder) -> {
        final List<Property<?>> _properties = builder.getProperties();
        Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
        return new FlexHorizontalDirectionalBlock(props, propertyDefaultValues){

            protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                super.m_7926_(builder1);
                _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
            }
        };
    }, "solid", false, false, false, new Property[]{HorizontalDirectionalBlock.f_54117_});
    public static final FlexBlockType<FlexRotatedPillarBlock> ROTATED_PILLAR = FlexBlockType.register("rotated_pillar", (JsonObject data) -> (props, builder) -> {
        final List<Property<?>> _properties = builder.getProperties();
        Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
        return new FlexRotatedPillarBlock(props, propertyDefaultValues){

            protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                super.m_7926_(builder1);
                _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
            }
        };
    }, "solid", false, new Property[]{RotatedPillarBlock.f_55923_});
    public static final FlexBlockType<FlexSlabBlock> SLAB = FlexBlockType.register("slab", (JsonObject data) -> (props, builder) -> {
        final List<Property<?>> _properties = builder.getProperties();
        Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
        return new FlexSlabBlock(props, propertyDefaultValues){

            protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                super.m_7926_(builder1);
                _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
            }
        };
    }, "solid", false, false, false, new Property[]{SlabBlock.f_56353_, SlabBlock.f_56354_});
    public static final FlexBlockType<FlexStairsBlock> STAIRS = FlexBlockType.register("stairs", (JsonObject data) -> {
        MutableObject parent = new MutableObject();
        JParse.begin(data).ifKey("stairs_parent", val -> val.string().map(ResourceLocation::new).handle(arg_0 -> ((MutableObject)parent).setValue(arg_0)));
        return (props, builder) -> {
            ResourceLocation parentName = (ResourceLocation)parent.getValue();
            if (parentName == null) {
                BlockBuilder parentBuilder = (BlockBuilder)builder.getParent();
                if (parentBuilder == null) {
                    throw new IllegalStateException("Stairs blocks need a parent block, but none has been declared.");
                }
                parentName = parentBuilder.getRegistryName();
            }
            RegistryObject parentBlock = RegistryObject.create((ResourceLocation)parentName, (IForgeRegistry)ForgeRegistries.BLOCKS);
            final List<Property<?>> _properties = builder.getProperties();
            Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
            return new FlexStairsBlock(props, propertyDefaultValues, () -> ((Block)parentBlock.get()).m_49966_()){

                protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                    super.m_7926_(builder1);
                    _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
                }
            };
        };
    }, "solid", false, false, false, new Property[]{StairBlock.f_56841_, StairBlock.f_56842_, StairBlock.f_56843_, StairBlock.f_56844_});
    public static final FlexBlockType<FlexWallBlock> WALL = FlexBlockType.register("wall", (JsonObject data) -> (props, builder) -> {
        final List<Property<?>> _properties = builder.getProperties();
        Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
        return new FlexWallBlock(props, propertyDefaultValues){

            protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                super.m_7926_(builder1);
                _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
            }
        };
    }, "solid", false, false, false, new Property[]{WallBlock.f_57949_, WallBlock.f_57950_, WallBlock.f_57951_, WallBlock.f_57952_, WallBlock.f_57953_, WallBlock.f_57954_});
    public static final FlexBlockType<FlexFenceBlock> FENCE = FlexBlockType.register("fence", (JsonObject data) -> (props, builder) -> {
        final List<Property<?>> _properties = builder.getProperties();
        Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
        return new FlexFenceBlock(props, propertyDefaultValues){

            protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                super.m_7926_(builder1);
                _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
            }
        };
    }, "solid", false, false, false, new Property[]{FenceBlock.f_52309_, FenceBlock.f_52310_, FenceBlock.f_52311_, FenceBlock.f_52312_, FenceBlock.f_52313_});
    public static final FlexBlockType<FlexFenceGateBlock> FENCE_GATE = FlexBlockType.register("fence_gate", (JsonObject data) -> {
        MutableObject blockSetType = new MutableObject();
        JParse.begin(data).key("wood_type", any -> any.string().map(ResourceLocation::new).handle(arg_0 -> ((MutableObject)blockSetType).setValue(arg_0)));
        return (props, builder) -> {
            final List<Property<?>> _properties = builder.getProperties();
            Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
            String woodTypeName = ((ResourceLocation)blockSetType.getValue()).toString();
            WoodType woodType = WoodType.m_61843_().filter(w -> Objects.equals(w.f_61839_(), woodTypeName)).findFirst().orElseThrow();
            return new FlexFenceGateBlock(props, woodType, propertyDefaultValues){

                protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                    super.m_7926_(builder1);
                    _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
                }
            };
        };
    }, "solid", false, false, false, new Property[]{FenceGateBlock.f_53341_, FenceGateBlock.f_53342_, FenceGateBlock.f_53343_});
    public static final FlexBlockType<FlexLeavesBlock> LEAVES = FlexBlockType.register("leaves", (JsonObject data) -> (props, builder) -> {
        final List<Property<?>> _properties = builder.getProperties();
        Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
        return new FlexLeavesBlock(props, propertyDefaultValues){

            protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                super.m_7926_(builder1);
                _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
            }
        };
    }, "cutout_mipped", true, false, false, new Property[]{LeavesBlock.f_54418_, LeavesBlock.f_54419_});
    public static final FlexBlockType<FlexDoorBlock> DOOR = FlexBlockType.register("door", (JsonObject data) -> {
        MutableObject blockSetType = new MutableObject();
        JParse.begin(data).key("block_set_type", any -> any.string().map(ResourceLocation::new).handle(arg_0 -> ((MutableObject)blockSetType).setValue(arg_0)));
        return (props, builder) -> {
            final List<Property<?>> _properties = builder.getProperties();
            Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
            String woodTypeName = ((ResourceLocation)blockSetType.getValue()).toString();
            BlockSetType woodType = BlockSetType.m_271801_().filter(w -> Objects.equals(w.f_271253_(), woodTypeName)).findFirst().orElseThrow();
            return new FlexDoorBlock(props, woodType, propertyDefaultValues){

                protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                    super.m_7926_(builder1);
                    _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
                }
            };
        };
    }, "cutout", true, false, false, new Property[]{DoorBlock.f_52726_, DoorBlock.f_52727_, DoorBlock.f_52728_, DoorBlock.f_52729_, DoorBlock.f_52730_});
    public static final FlexBlockType<FlexTrapdoorBlock> TRAPDOOR = FlexBlockType.register("trapdoor", (JsonObject data) -> {
        MutableObject blockSetType = new MutableObject();
        JParse.begin(data).key("block_set_type", any -> any.string().map(ResourceLocation::new).handle(arg_0 -> ((MutableObject)blockSetType).setValue(arg_0)));
        return (props, builder) -> {
            final List<Property<?>> _properties = builder.getProperties();
            Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
            String woodTypeName = ((ResourceLocation)blockSetType.getValue()).toString();
            BlockSetType woodType = BlockSetType.m_271801_().filter(w -> Objects.equals(w.f_271253_(), woodTypeName)).findFirst().orElseThrow();
            return new FlexTrapdoorBlock(props, woodType, propertyDefaultValues){

                protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                    super.m_7926_(builder1);
                    _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
                }
            };
        };
    }, "cutout", true, false, false, new Property[]{TrapDoorBlock.f_57514_, TrapDoorBlock.f_57515_, TrapDoorBlock.f_57516_, TrapDoorBlock.f_57517_});
    public static final FlexBlockType<FlexLiquidBlock> LIQUID = FlexBlockType.register("liquid", (JsonObject data) -> {
        ObjValue extras = JParse.begin(data);
        MutableObject fluid = new MutableObject();
        extras.key("fluid", any -> any.string().map(ResourceLocation::new).handle(arg_0 -> ((MutableObject)fluid).setValue(arg_0)));
        return (props, builder) -> {
            final List<Property<?>> _properties = builder.getProperties();
            Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
            ResourceLocation fluidName = fluid.getValue() != null ? (ResourceLocation)fluid.getValue() : builder.getRegistryName();
            Lazy fluidSupplier = Lazy.of(() -> {
                Fluid fluidObj = (Fluid)Utils.getOrCrash(ForgeRegistries.FLUIDS, fluidName);
                if (!(fluidObj instanceof FlowingFluid)) {
                    throw new RuntimeException("LiquidBlock requires a flowing fluid");
                }
                FlowingFluid flowing = (FlowingFluid)fluidObj;
                return flowing;
            });
            return new FlexLiquidBlock(props.m_278788_(), propertyDefaultValues, (Supplier)fluidSupplier){

                protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder1) {
                    super.m_7926_(builder1);
                    _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
                }
            };
        };
    }, "translucent", true, false, false, new Property[]{LiquidBlock.f_54688_});
    private final IBlockSerializer<T> factory;
    private final List<Property<?>> stockProperties;
    private final String defaultLayer;
    private final boolean defaultSeeThrough;
    private final boolean defaultIgnitedByLava;
    private final boolean defaultReplaceable;

    public static void init() {
    }

    @Deprecated(forRemoval=true)
    public static <T extends Block> FlexBlockType<T> register(String name, IBlockSerializer<T> factory, String defaultLayer, boolean defaultSeeThrough, Property<?> ... stockProperties) {
        return FlexBlockType.register(name, factory, defaultLayer, defaultSeeThrough, false, false, stockProperties);
    }

    public static <T extends Block> FlexBlockType<T> register(String name, IBlockSerializer<T> factory, String defaultLayer, boolean defaultSeeThrough, boolean defaultIgnitedByLava, boolean defaultReplaceable, Property<?> ... stockProperties) {
        return (FlexBlockType)Registry.m_122961_(ThingRegistries.BLOCK_TYPES, (String)name, new FlexBlockType<T>(factory, Arrays.asList(stockProperties), defaultLayer, defaultSeeThrough, defaultIgnitedByLava, defaultReplaceable));
    }

    private FlexBlockType(IBlockSerializer<T> factory, List<Property<?>> stockProperties, String defaultLayer, boolean defaultSeeThrough, boolean defaultIgnitedByLava, boolean defaultReplaceable) {
        this.factory = factory;
        this.stockProperties = stockProperties;
        this.defaultLayer = defaultLayer;
        this.defaultSeeThrough = defaultSeeThrough;
        this.defaultIgnitedByLava = defaultIgnitedByLava;
        this.defaultReplaceable = defaultReplaceable;
    }

    public IBlockFactory<T> getFactory(JsonObject data) {
        return this.factory.createFactory(data);
    }

    public List<Property<?>> getStockProperties() {
        return this.stockProperties;
    }

    public String getDefaultLayer() {
        return this.defaultLayer;
    }

    public boolean isDefaultSeeThrough() {
        return this.defaultSeeThrough;
    }

    public boolean isDefaultIgnitedByLava() {
        return this.defaultIgnitedByLava;
    }

    public boolean isDefaultReplaceable() {
        return this.defaultReplaceable;
    }

    public String toString() {
        return "BlockType{" + ThingRegistries.BLOCK_TYPES.m_7981_((Object)this) + "}";
    }
}

